# Installation Guide
## OBGYN Research & Collaboration Platform

This guide will walk you through the complete installation process.

---

## 📋 Pre-Installation Checklist

- [ ] XAMPP installed and running
- [ ] Apache and MySQL services started
- [ ] PHP 7.4+ available
- [ ] At least 500MB free disk space
- [ ] Modern web browser (Chrome, Firefox, Safari, Edge)

---

## 🔧 Step-by-Step Installation

### Step 1: Verify XAMPP Installation

1. Open XAMPP Control Panel
2. Start **Apache** service (should show green)
3. Start **MySQL** service (should show green)
4. Click **Admin** button next to MySQL to open phpMyAdmin

### Step 2: Create Database

**Option A: Using phpMyAdmin (Recommended)**

1. Open phpMyAdmin: http://localhost/phpmyadmin
2. Click on "New" in the left sidebar
3. Database name: `obgyn_research_platform`
4. Collation: `utf8mb4_unicode_ci`
5. Click "Create"
6. Select the newly created database
7. Click "Import" tab
8. Click "Choose File" and select: `D:\Coding\xampp\htdocs\obgyn-research-platform\database\schema.sql`
9. Click "Go" at the bottom
10. Wait for success message: "Import has been successfully finished"

**Option B: Using MySQL Command Line**

```bash
# Open XAMPP Shell or Command Prompt
cd C:\xampp\mysql\bin

# Login to MySQL
mysql -u root -p
# (Press Enter when asked for password if no password is set)

# Create database
CREATE DATABASE obgyn_research_platform CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

# Use the database
USE obgyn_research_platform;

# Import schema
SOURCE D:/Coding/xampp/htdocs/obgyn-research-platform/database/schema.sql;

# Verify tables were created
SHOW TABLES;

# Exit
EXIT;
```

### Step 3: Configure Database Connection

The default configuration should work with standard XAMPP installation. If you have custom settings:

1. Open: `D:\Coding\xampp\htdocs\obgyn-research-platform\config\database.php`
2. Update these values if needed:
   ```php
   define('DB_HOST', 'localhost');      // Usually localhost
   define('DB_USER', 'root');           // Default XAMPP user
   define('DB_PASS', '');               // Default is empty
   define('DB_NAME', 'obgyn_research_platform');
   ```

### Step 4: Set Directory Permissions

Ensure upload directories are writable:

**On Windows:**
- Right-click on `assets/uploads` folder
- Properties → Security → Edit
- Add "Full Control" for "Users"

**On Linux/Mac:**
```bash
chmod -R 755 assets/uploads
```

### Step 5: Configure Email (Optional but Recommended)

For email verification and notifications:

1. Open: `config/config.php`
2. Update SMTP settings:
   ```php
   define('SMTP_HOST', 'smtp.gmail.com');
   define('SMTP_PORT', 587);
   define('SMTP_USERNAME', 'your-email@gmail.com');
   define('SMTP_PASSWORD', 'your-app-password');
   ```

**For Gmail:**
- Enable 2-Step Verification
- Generate App Password: https://myaccount.google.com/apppasswords
- Use the generated password in config

### Step 6: Test Installation

1. Open browser and navigate to: http://localhost/obgyn-research-platform/
2. You should see the home page with statistics showing 0
3. Click "Register" to create your first account

### Step 7: Create Admin Account

**Method 1: Register and Promote**

1. Register a new account through the website
2. Check your email for verification (if configured)
3. Open phpMyAdmin
4. Navigate to `obgyn_research_platform` database
5. Click on `users` table
6. Find your user record
7. Click "Edit"
8. Change:
   - `role_id` to `1` (Super Admin)
   - `status` to `active`
   - `email_verified` to `1`
9. Click "Go"
10. Now login with your credentials

**Method 2: Direct SQL Insert**

```sql
-- Insert admin user directly
INSERT INTO users (email, password, first_name, last_name, role_id, status, email_verified)
VALUES (
    'admin@obgynresearch.com',
    '$2y$12$LQv3c1yqBWVHxkd0LHAkCOYz6TtxMQJqhN8/LewY5OfmcKk6wKLyG', -- password: Admin@123
    'Admin',
    'User',
    1,
    'active',
    1
);

-- Create researcher profile
INSERT INTO researcher_profiles (user_id)
SELECT id FROM users WHERE email = 'admin@obgynresearch.com';
```

**Default Admin Credentials (if using Method 2):**
- Email: admin@obgynresearch.com
- Password: Admin@123
- **⚠️ CHANGE THIS PASSWORD IMMEDIATELY AFTER FIRST LOGIN**

---

## ✅ Verification Steps

### 1. Test Home Page
- URL: http://localhost/obgyn-research-platform/
- Should display: Hero section, statistics, features

### 2. Test Registration
- Click "Register"
- Fill in the form
- Submit
- Should see success message

### 3. Test Login
- Click "Login"
- Enter credentials
- Should redirect to dashboard

### 4. Test Admin Panel (if admin)
- Login as admin
- Click "Admin" in navigation
- Should see admin dashboard

### 5. Test File Upload
- Go to researcher dashboard
- Try uploading a profile picture
- Should upload successfully

---

## 🐛 Common Issues & Solutions

### Issue 1: "Database connection failed"
**Solution:**
- Verify MySQL is running in XAMPP
- Check database name is correct: `obgyn_research_platform`
- Verify credentials in `config/database.php`

### Issue 2: "Call to undefined function"
**Solution:**
- Check PHP version: `php -v` (must be 7.4+)
- Enable required extensions in `php.ini`:
  - extension=pdo_mysql
  - extension=openssl
  - extension=mbstring
  - extension=fileinfo

### Issue 3: "Permission denied" on file upload
**Solution:**
- Set folder permissions to 755 or 777
- On Windows: Give "Full Control" to Users group
- Verify path: `assets/uploads/` exists

### Issue 4: "Headers already sent"
**Solution:**
- Check for whitespace before `<?php` in files
- Ensure no output before `session_start()`
- Check file encoding is UTF-8 without BOM

### Issue 5: Email not sending
**Solution:**
- Verify SMTP settings in `config/config.php`
- For Gmail: Use App Password, not regular password
- Check firewall isn't blocking port 587
- Test with a simple PHP mail script

### Issue 6: CSS/JS not loading
**Solution:**
- Check `SITE_URL` in `config/config.php`
- Should be: `http://localhost/obgyn-research-platform`
- Clear browser cache (Ctrl+F5)
- Check Apache is serving static files

### Issue 7: Session issues
**Solution:**
- Check session.save_path in php.ini
- Ensure temp directory is writable
- Restart Apache after php.ini changes

---

## 🔒 Security Recommendations

### Before Going Live:

1. **Change Database Password**
   ```sql
   SET PASSWORD FOR 'root'@'localhost' = PASSWORD('strong_password');
   ```

2. **Update Config**
   - Set strong database password
   - Change SMTP credentials
   - Update SITE_URL to production domain

3. **Disable Error Display**
   ```php
   // In config/config.php
   error_reporting(0);
   ini_set('display_errors', 0);
   ```

4. **Enable HTTPS**
   - Get SSL certificate
   - Update SITE_URL to https://
   - Force HTTPS in .htaccess

5. **Set Secure Permissions**
   - Files: 644
   - Directories: 755
   - config/: 750

6. **Regular Backups**
   - Database: Daily
   - Files: Weekly
   - Store offsite

---

## 📊 Post-Installation Tasks

### 1. Configure Platform Settings
- Login as admin
- Go to Admin → Settings
- Set site name, email, timezone
- Configure upload limits

### 2. Create Categories
- Go to Admin → Categories
- Add research categories:
  - Clinical
  - Surgical
  - Fertility
  - Urogynecology
  - Menopause

### 3. Add Initial Content
- Create "About" page
- Add "Terms of Service"
- Add "Privacy Policy"
- Create welcome announcement

### 4. Test All Features
- User registration
- Email verification
- Study creation
- File uploads
- Messaging
- Search functionality

### 5. Monitor Logs
- Check `audit_logs` table
- Review `login_attempts`
- Monitor error logs

---

## 📞 Support

If you encounter issues not covered here:

1. Check the main README.md
2. Review error logs in XAMPP
3. Check browser console for JavaScript errors
4. Verify all files are uploaded correctly

---

## 🎉 Installation Complete!

Your OBGYN Research Platform is now ready to use!

**Next Steps:**
1. Login to admin panel
2. Configure platform settings
3. Create initial content
4. Invite researchers
5. Start collaborating!

**Access URLs:**
- Home: http://localhost/obgyn-research-platform/
- Login: http://localhost/obgyn-research-platform/login.php
- Register: http://localhost/obgyn-research-platform/register.php
- Admin: http://localhost/obgyn-research-platform/admin/dashboard.php

---

**Version:** 1.0  
**Last Updated:** January 2025  
**For:** Prof. Hesham Al Inany – Ganna Research Center
